###############################################################
#
# wrapper to convert CGI->parameters() to unicode strings
#
# see also: http://www.cybaea.net/Blogs/Mason-utf-8-clean.html
#
# enable in /etc/apache2/sites-enabled/mkc-admin with:
#
#  PerlAddVar MasonPlugins "MasonX::Plugin::UTF8"
#

package MasonX::Plugin::UTF8;
use base qw(HTML::Mason::Plugin);
use Encode qw(decode);
use Time::HiRes qw(gettimeofday);
use HTTP::Date;
use Data::Dumper;

use warnings;
use strict;

our $debug = 1;

sub time_log {
    my $context = shift;
    return if ref($context) ne 'ARRAY';    # tests

    my ( $seconds, $microseconds ) = gettimeofday;
    my $date = time2str($seconds) . " .${microseconds} ms";

    my $full_url = $context->[0]->cgi_object->url( -full => 1, -query => 1 );

    return ( $date, $full_url );
}

sub start_request_hook {
    my ( $self, $context ) = @_;

    my $args_ref = $context->args();

    foreach my $arg ( @{$args_ref} ) {
        if ( !Encode::is_utf8($arg) ) {
            $arg = decode( 'UTF-8', $arg, Encode::FB_CROAK );
        }
    }

    my ( $date, $full_url ) = time_log($context);
    return if !$date;    # tests

    warn "HTML::Mason start $date $full_url\n" if $debug >= 1;
    push @{ $self->{timers} }, Time::HiRes::time;

    return;
}

sub end_component_hook {
    my ( $self, $context ) = @_;

    my ( $date, $full_url ) = $self->time_log($context);
    return if !$date;    # tests

    my $old_time = pop @{ $self->{timers} };
    return if !defined $old_time;

    # time in ms
    my $elapsed = int( ( Time::HiRes::time - $old_time ) * 1000 );
    warn "HTML::Mason end $date $full_url [$elapsed ms]\n" if $debug >= 1;
}

1;
