%define idmetaversion %(. ./IDMETA; echo $VERSION|tr -d '\n')
Summary: The web-based administrative console for the MasterKey suite
Name: masterkey-admin
Version: %{idmetaversion}
Release: 1.indexdata
License: IndexData
Group: Applications/Internet
Vendor: Index Data ApS <info@indexdata.com>
Source: masterkey-admin-%{version}.tar.gz
BuildArch: noarch
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: perl
BuildRequires:  perl(ExtUtils::MakeMaker)
BuildRequires: ruby
Packager: Mike Taylor <mike@indexdata.com>
URL: http://www.indexdata.com/masterkey/

Requires: mod_perl
Requires: perl-libapreq2
# Hopefully includes Apache2::Cookie/Request
Requires: perl-File-Slurp
Requires: perl-FreezeThaw
Requires: perl-HTML-Parser
# For HTML::Entities
Requires: perl-HTML-TagCloud
Requires: perl-libwww-perl
Requires: libnet-z3950-zoom-perl
Requires: perl-URI
# For URI::Escape
Requires: perl-XML-LibXML-Simple
Requires: perl-XML-Simple
Requires: perl-HTML-Mason
Requires: perl-Time-Piece
Requires: perl-IO-String
# For billing.cgi
Requires: perl-Text-CSV

%description
The MasterKey Admin Console (MKAdmin for short) is the Administrative
user-interface for the MasterKey metasearcher.  This package provides
a Perl module, Masterkey::Admin, and its associated classes, together
with the relevant associated web scaffolding to provide an
administrative user-interface to the MasterKey metasearcher, using the
Web Services API of the Torus (Translucent Recent Store).

%prep
%setup

%build
%{__perl} Makefile.PL PREFIX=/usr INSTALLDIRS=vendor
%{__make}

%pre
rm -rf /etc/masterkey/admin/include

%install
%{__rm} -rf %{buildroot}
%{__make} pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} ';'
find %{buildroot} -depth -type d -exec rmdir {} 2>/dev/null ';'
find %{buildroot} -type f -name CPU.bs -exec rm -f {} ';'
# Perl's make install seems to create both uncompressed AND compressed
# versions of the manual pages, which confuses /usr/lib/rpm/brp-compress
find $RPM_BUILD_ROOT/usr/share/man -name '*.gz' -exec rm -f '{}' \;
# Install htdocs
mkdir -p $RPM_BUILD_ROOT%{_datadir}/masterkey/admin
cp -rp web/htdocs $RPM_BUILD_ROOT%{_datadir}/masterkey/admin/htdocs

# Install config/system
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/masterkey/admin/conf.d
cp -rp config/system $RPM_BUILD_ROOT%{_sysconfdir}/masterkey/admin/
ln -s -f system $RPM_BUILD_ROOT%{_sysconfdir}/masterkey/admin/include

# Install documentation
DOCDIR=$RPM_BUILD_ROOT%{_datadir}/doc/masterkey-admin
mkdir -p $DOCDIR
cp -p README README.MacOS $DOCDIR/
cp -p config/README $DOCDIR/README.config
cp -p web/config/apache2.0/README $DOCDIR/README.apache2
cp -p web/config/apache2.0/README.mac $DOCDIR/README.apache2.mac
cp -p web/config/apache2.0/mkadmin-example.conf $DOCDIR/
#sleep 9999

%clean
%{__rm} -rf %{buildroot}
# cp -rp ${RPM_BUILD_ROOT} /tmp/SAVED
#rm -fr ${RPM_BUILD_ROOT}

%post
# By convention, MKAdmin applications are configured to cache
# their compiled HTML::Mason components in /tmp/mkadmin-mason.
# These cached compilations sometimes live on after the source
# has been replaced by a newer version, yielding subtle bugs:
# to prevent this, we need to remove the old cache.
rm -rf /tmp/mkadmin-mason

# set permission for billing statistics
sudo mkdir -p /var/lib/masterkey/billing
sudo chmod o+x /var/lib/masterkey/torus2
sudo chown apache:apache /var/lib/masterkey/billing

### Do we need to do anything to libapache2-mod-apreq2?

# We need to reload Apache2 so that it recognises the new modules.
/etc/init.d/httpd condrestart

# These clauses are not needed if the symlink is part of the package data
#	# Remove any vestiges of the old "include" directory, then make it a
#	# symbolic link to the new equivalent "system" directory for backwards
#	# compatibility.
#	echo "About to remove old /etc/masterkey/admin/include"
#	ls -ld /etc/masterkey/admin/include
#	rm -rf /etc/masterkey/admin/include
#	echo "About to make symlink /etc/masterkey/admin/include"
#	ln -s -f system /etc/masterkey/admin/include
#	echo "Made symlink /etc/masterkey/admin/include"
#	ls -ld /etc/masterkey/admin/include
#	
#	%postun
#	rm -f /etc/masterkey/admin/include

%files
%defattr(-,root,root)
%config %{_sysconfdir}/masterkey/admin/system
%config %{_sysconfdir}/masterkey/admin/include
%dir %{_sysconfdir}/masterkey/admin/conf.d
%{_datadir}/masterkey/admin/htdocs
%doc %{_datadir}/doc/masterkey-admin
%{_bindir}/ndbm-dump-sessions
%{_bindir}/select-targets
%{_bindir}/torus-sed
%{_bindir}/test-usi-targets
%{_bindir}/remove-mk2-orphans
%{_bindir}/translate-mk-config
%{_datadir}/man/man1/ndbm-dump-sessions.1.gz
%{_datadir}/man/man1/test-usi-targets.1.gz
%{_datadir}/man/man1/remove-mk2-orphans.1.gz
%{_datadir}/man/man1/torus-sed.1.gz
%doc %{_datadir}/man/man3/Masterkey::Admin::*.3pm.gz
%{perl_vendorlib}

%changelog
* Thu Jul  8 2010 Mike Taylor <mike@indexdata.com>
- First Red Hat packaged version.
