<%args>
$udb
$context
$query => undef
</%args>
<%perl>
my $admin = $m->notes("admin");
my $user = $m->comp("/mc/utils/user.mc", require => 1) or return;
my $identityId = $user->field("identityId");
my $ninjaUrl = $admin->conf("ninjaTestUrl") || return;
my $usiUrl   = $admin->conf("usiBaseUrl") || "http://ebsco1.indexdata.com:9000/";
$usiUrl .= "/" if $usiUrl !~ /\/$/; # Add trailing slash if missing: Ninja needs it
my $torusUrl = $admin->conf("ninjaTestTorusUrl");
if (!$torusUrl) {
    $torusUrl = $admin->torus()->ws();
    # This is of the form http://x.usi.indexdata.com/torus2/searchable
    # We only want the prefix http://x.usi.indexdata.com/
    if ($torusUrl =~ s/torus2\/searchable$//) {
	#warn "torusUrl shortened to '$torusUrl'"
    } elsif ($torusUrl =~ s/torus2\/global$//) {
	# Consortium-level: testing doesn't work here
	return;
    } else {
	die "torusUrl does not end with .../torus2/searchable: '$torusUrl'";
    }
}

my $url = $ninjaUrl;
$url .= "?i=" . uri_escape_utf8($udb);
$url .= "&b=" . uri_escape_utf8($usiUrl);
# No need to specify null "e" (ZeeRex base-URL)
$url .= "&t=" . uri_escape_utf8($torusUrl);
$url .= "&r=" . uri_escape_utf8($identityId);

my $endUserAuth = $m->notes("endUserAuth");
if (defined $endUserAuth && $endUserAuth eq "__NONE__") {
    # It's __NONE__, meaning we tried once to determine it but
    # there was no positive result. No need to try again.
} elsif (defined $endUserAuth) {
    $url .= "&u=" . uri_escape_utf8($endUserAuth);
} else {
    # First attempt to determine $endUserAuth
    my $uadmin = new Masterkey::Admin("identity");
    my $fullquery = "identityId==$identityId";
    my $rs = $uadmin->torus()->sortedRecords("DUMMY", $fullquery, $user);
    if ($rs->count() == 0) {
	# Must be an USI-style application without end-users
	# Don't add "u" param, just reply on "r". Mark the parameter
	# as unavailable to avoid repeated attempts.
	$m->notes("endUserAuth", "__NONE__");
    } else {
	my $rec = $rs->record(0);
	$endUserAuth = $rec->field("userName") . '/' . $rec->field("password");
	$url .= "&u=" . uri_escape_utf8($endUserAuth);
	$m->notes("endUserAuth", $endUserAuth);
    }
}

# No need to specify "e" as multithreading is off by default
my $text = "Test the target described by this record using the Ninja Test";
</%perl>
      &nbsp;
      <a href="<% encode_entities($url)
	%>" title="<% $text %>"><& icon.mc, context => $context, icon => "ninja", text => $text &></a>
