<%args>
$query => undef
</%args>
   <h2>Manage master overrides</h2>
<%perl>
my @masters;
my $admin = $m->notes("admin");

eval {
    my $torus = $admin->torus();
    my $user = $m->comp("/mc/utils/user.mc", auth => "manage master overrides") or return;
    my $realm = $user->field("identityId");

    @masters = sort { $a->id() cmp $b->id() } $torus->masters($realm, $query);
}; if ($@) {
    my $error = $@;
    if ($error =~ /Error 404 - Missing master records directory/) {
	print qq{<p title="$error">No master record directory exists. Add a master record?</p>\n};
    } else {
	die $@;
    }
}

</%perl>
   <table class="list">
    <tr>
     <th>ID</th>
     <th>Label</th>
     <th>Match Query</th>
     <th>Overrides</th>
     <th>Edit</th>
     <th>Delete</th>
    </tr>
% foreach my $i (0 .. @masters-1) {
%     my $master = $masters[$i];
    <tr>
     <td><% encode_entities($master->id()) %></td>
     <td><% encode_entities($master->label()) %></td>
     <td><% encode_entities($master->matchQuery()) %></td>
     <td>
% foreach my $name ($master->fields("master-override")) {
%      next if grep { $name eq $_ } (qw(realm creationDate lastModified));
       <% encode_entities($name) %>:
       <% encode_entities($master->field($name, "master-override")) %>
       <br/>
% }
     </td>
     <td>
% my $etext = "Edit this master";
      <a href="editMaster.html?id=<% encode_entities($master->id())
	%>" title="<% $etext %>"><& /mc/link/icon.mc, context => "list", icon => "edit", text => $etext &></a>
     </td>
     <td>
% my $dtext = "Delete this master";
      <a href="deleteMaster.html?id=<% encode_entities($master->id())
	%>" title="<% $dtext %>"><& /mc/link/icon.mc, context => "list", icon => "delete", text => $dtext &></a>
     </td>
    </tr>
% }
    <tr>
     <td class="right" colspan="5">Add master</td>
     <td colspan="2">
% my $atext = "Add new master";
      <a href="addMaster.html" title="<% $atext %>"><& /mc/link/icon.mc, context => "list", icon => "new", text => $atext &></a>
     </td>
    </tr>
   </table>
