<%args>
$record
$usi => undef
</%args>
<%once>
use Masterkey::Admin::Test;
use Masterkey::Admin::Output;
use ZOOM;
</%once>
% our $_zurl_for_reporting = $record->field("zurl");
% my $admin = $m->notes("admin");
% my $test = new Masterkey::Admin::Test($admin, $usi, $record);
   <h2>Target test (<% $test->caption() %>): <% encode_entities($record->displayName()) %></h2>
  <p style="padding-top: 1em; padding-bottom: 1em">
<& /mc/link/actions.mc, context => "toolbar", user => $m->notes('user'), record => $record &>
  </p>
<%perl>
my $out = new Masterkey::Admin::List();
my $apperror;
eval {
    $apperror = $m->comp("doit", out => $out, %ARGS, test => $test);
}; if ($@) {
    my $syserror = $@;
    $syserror =~ s/(.*) at .*/$1/s;
    $out->render(0);
</%perl>
    <p class="error">
     Z39.50 testing of target '<% encode_entities($_zurl_for_reporting) %>' failed: <% encode_entities($syserror) %>
    </p>
<%perl>
    return;
}

$out->render(0);
if (defined $apperror) {
</%perl>
    <p class='error'>
     Server error: <% encode_entities($apperror) %>
    </p>
<%perl>
    return;
}
</%perl>
   <p>Testing complete.</p>
   <p style="padding-top: 1em; padding-bottom: 1em">
<& /mc/link/actions.mc, context => "toolbar", user => $m->notes('user'), record => $record &>
   </p>
<%def doit>
<%args>
$out
$test
$record
$usi => undef
$debug => 0
</%args>
<%perl>
{
    my $admin = $m->notes("admin");
    my $adminUser = $m->comp("/mc/utils/user.mc");

    my $conn = create ZOOM::Connection();
    $out->item("Created connection object");
    $conn->option(saveAPDU => 1) if $debug;
    $out->item("Debug = $debug");

    my($zurl, %options1, %options2);
    ($zurl, %options1) = $test->zurlAndAuth($out, $adminUser);
    ($zurl, %options2) = $test->backendAuth($out, $zurl);
    our $_zurl_for_reporting = $zurl; # Nasty hack to make available for error-report
    $out->item("Testing server at '" . encode_entities($zurl) . "'");

    my %options = (%options1, %options2);
    foreach my $key (keys %options) {
	$m->comp("maybe_set_attribute", out => $out, obj => $conn, key => $key, value => $options{$key});
    }

    $m->comp("maybe_set_attribute", out => $out, obj => $conn, key => "sru", value => $test->sruSetting());
    $m->comp("maybe_set_attribute", out => $out, obj => $conn, key => "proxy", value => $record->field("zproxy"));
    $m->comp("maybe_set_attribute", out => $out, obj => $conn, key => "timeout", value => 60);
    $m->comp("maybe_set_attribute", out => $out, obj => $conn, key => "rpnCharset", value => $record->field("queryEncoding"));

    $conn->connect($zurl);
    $out->item("Connected");

    if ($debug) {
	$out->item("Init APDU: <pre>" . encode_entities($conn->option("APDU")) . "</pre>");
	$conn->option("saveAPDU" => 1); # Reset
    }

    my $out2 = new Masterkey::Admin::List("Testing searching:");
    $out->add($out2);
    die "no UDB defined for this target" if !$record->field("udb");

    my $cclset = "";
    foreach my $field ($record->fields()) {
	my $val = $record->field($field);
	if ($field =~ s/^cclmap_// && $val) {
	    $cclset .= "$field $val\n";
	}
    }
    $conn->option(cclqual => $cclset);
    $out2->display($cclset, "CCL qualifier set");

    my $saved = undef;
    my $nSearchesTried = 0;
    foreach my $field ($record->fields(), "*") {
	my $index = $field;
	my $attrs = $record->field($field);
	my $indexName;
	if ($field eq "*") {
	    last if defined $saved;
	    # Special case: if no searches are configured, try one with no attributes
	    $index = "term";
	    $indexName = "*";
	} elsif (!($index =~ s/^cclmap_//)) {
	    next;
	} elsif (!defined $attrs || $attrs eq "") {
	    next;
	} else {
	    $indexName = encode_entities($admin->fieldname($field));
	}

	my $term = $index eq "date" ?
	    ($record->field("dateTestingTerm") ||
	     $admin->conf("z3950DateTestingTerm") ||
	     "1998") :
	    ($record->field("testingTerm") ||
	     $admin->conf("z3950TestingTerm") ||
	     "water");

	my $queryIndex = $test->queryIndex($index);
	my $qstr;
	if ($index eq "term") {
	    $qstr = $term;
	} elsif ($index eq "date") {
	    my $dateTerm = ($record->field("dateTestingTerm") ||
			    $admin->conf("z3950DateTestingTerm") ||
			    "1998");
	    $qstr = "$term and $queryIndex=" . $dateTerm;
	} elsif ($index eq "peerreviewed" || $index eq "fulltext") {
	    $qstr = "$term and $queryIndex=1";
	} else {
	    $qstr = "$queryIndex=$term";
	}

	my $query = $test->makeQuery($qstr, $conn);
	my $qtype = ref($query);
	$qtype =~ s/^ZOOM::Query:://;
	$out2->item("$indexName: $qtype '$qstr' ... ");

	$m->flush_buffer();
	$nSearchesTried++;
	eval {
	    my $oldtime = time();
	    my $rs = $conn->search($query);
	    my $newtime = time();
	    my $secs = $newtime-$oldtime;
	    my $n = $rs->size();
	    $out2->appendToLastItem(" found $n records in $secs second" .
				    ($secs == 1 ? "" : "s") .
				    ($secs >= 30 ? " <b>SLOW</b>" : ""));
	    if (!defined $saved && $n > 0) {
		$saved = [ $qstr, $n ];
	    }
	    if ($debug) {
		$out2->item("Search APDU: <pre>" . encode_entities($conn->option("APDU")) . "</pre>");
		$conn->option("saveAPDU" => 1); # Reset
	    }
	    $rs->destroy();
	}; if ($@ && ref $@ && ref $@ eq "ZOOM::Exception" &&
	       ($@->code() == 114 ||
		($@->code() == 3 && $@->addinfo() eq "Task not found") ||
		($@->code() == 16 && $@->diagset() eq "info:srw/diagnostic/1") ||
		($@->code() == 2 && $@->addinfo() =~ /Unsupported index in CQL/))){
	    # The second of these conditions is a stopgap while the CF Engine is broken
	    # The last is for ProQuest's SRU servers, which return non-SRU diagnostics
	    $out2->appendToLastItem("<b>Index not supported</b>");
	} elsif ($@ && ref $@ && ref $@ eq "ZOOM::Exception" &&
		 ($@->code() == 2 && $@->addinfo() =~ /in addition to the indexes/)) {
	    $out2->appendToLastItem("Index not can not be used on its own, only with others");
	} elsif ($@) {
	    if ($debug) {
		$out2->item("Search APDU: <pre>" . encode_entities($conn->option("APDU")) . "</pre>");
		$conn->option("saveAPDU" => 1); # Reset
	    }
	    die $@;
	}
    }

    $out->item("Attempted $nSearchesTried searches");

    if ($nSearchesTried == 0) {
	$out->item("<b>Attributes were not defined for any search!</b>");	
    } elsif (!defined $saved) {
	$out->item("Skipping retrieval test: no index finds records");
    } else {
	my $out2 = new Masterkey::Admin::List("Testing retrieval");
	$out->add($out2);
	my($qstr, $oldn) = @$saved;
	my $query = $test->makeQuery($qstr, $conn);
	my $rs = $conn->search($query);
	my $n = $rs->size();
	$out2->item("Repeat search '$qstr' found $n records");
	$conn->option("saveAPDU" => 1) if $debug; # Reset

	if ($n != $oldn) {
	    $out2->item("(That's weird: hit count has changed)");
	}

	if ($n == 0) {
	    $out2->item("Skipping retrieval test: no hits to use");
	} else {
	    $m->comp("maybe_set_attribute", out => $out2, obj => $rs, key => "preferredRecordSyntax", value => $record->field("requestSyntax"));
	    $m->comp("maybe_set_attribute", out => $out2, obj => $rs, key => "elementSetName", value => $record->field("elementSet"));
	    # There is no similar setting for schema

	    my $rec;
	    eval {
		$out2->item("Requesting record in " . $rs->option("preferredRecordSyntax") . " format ...");
		$rec = $rs->record(0);
		$out2->appendToLastItem(" fetched record");
	    }; if ($@ && ref $@ && ref $@ eq "ZOOM::Exception" &&
		   ($@->code() == 239)) {
		$out2->appendToLastItem(" <b>record syntax not supported</b>");
	    } elsif ($@) {
		die $@;
	    }

	    if ($debug) {
		$out2->display($conn->option("APDU"), "Retrieval APDU");
		$conn->option("saveAPDU" => 1); # Reset
	    }

	    if ($test->useUSI()) {
		use XML::LibXML;
		my $xmlText = $rec->render();
		#print "<pre>", encode_entities($xmlText), "</pre>";
		#print "ref(\$xmlText) = ", ref($xmlText), "\n";
		my $dom = XML::LibXML->load_xml(string => $xmlText);
		#print "ref(\$dom) = ", ref($dom), "\n";
		my $root = $dom->documentElement();
		#print "ref(\$root) = ", ref($root), "\n";
		my $xpc = new XML::LibXML::XPathContext($root);

		my($titleXPath, $linkXPath);
		if ($root->nodeName() eq "simpledc" || # Original version of MKC's Dublin Core record
		    $root->nodeName() eq "srw_dc:dc") { # Changed version of MKC's Dublin Core record *sigh*
		    $xpc->registerNs('dc', 'http://purl.org/dc/elements/1.1/');
		    $xpc->registerNs('id', 'http://indexdata.com/xml/dcExtension/');
		    $titleXPath = "//dc:title";
		    $linkXPath = "//id:electronic-url";
		} else {
		    # The record will be in USI's extended-MODS 3.4 format
		    $xpc->registerNs('m', 'http://www.loc.gov/mods/v3');
		    $titleXPath = "/m:mods/m:titleInfo/m:title";
		    $linkXPath = "/m:mods/m:location/m:url[\@usage='primary']";
		}

		my $title = $xpc->findvalue($titleXPath);
		die "title is empty -- maybe retrieval failed?  Record is:\n$xmlText"
		    if !defined $title || $title eq "";
		my @url = $xpc->findnodes($linkXPath);
		if (@url == 1) {
		    $out2->item('Title: <i><a href="' . encode_entities($url[0]->textContent()) . '">' . encode_entities($title) . "</a></i>");
		} else {
		    my $out3 = new Masterkey::Admin::List("Title: <i>" . encode_entities($title) . "</i> has " . scalar(@url) . " links");
		    $out2->add($out3);
		    foreach my $url (@url) {
			$out3->item('<a href="' . encode_entities($url->textContent()) . '">' . encode_entities($url->textContent()) . "</a>");
		    }
		}
	    }
	}

	$rs->destroy();
    }

    if ($record->field("piggyback") == 0) {
	$out->item("Not testing piggybacking: target does not claim support");
    } elsif (!defined $saved) {
	$out->item("Skipping piggyback test: no index finds records");
    } else {
	my $out2 = new Masterkey::Admin::List("Testing piggybacking");
	$out->add($out2);
	my($qstr, $oldn) = @$saved;
	my $query = $test->makeQuery($qstr, $conn);
	$conn->option(piggyback => 1);
	$conn->option(count => 1);
	my $rs;
	eval {
	    $rs = $conn->search($query);
	}; if ($@ && ref $@ && ref $@ eq "ZOOM::Exception" &&
	       ($@->code() == 1005)) {
	    die "target rejected piggybacking request"
	} elsif ($@) {
	    die $@;
	}

	my $n = $rs->size();
	$out2->item("Piggyback search '$qstr' found $n records");
	if ($n != $oldn) {
	    $out2->item("(That's weird: hit count has changed)");
	}

	my $rec;
	eval {
	    $out2->item("Requesting immediate record ...");
	    $rec = $rs->record_immediate(0);
	}; if ($@) {
	    die $@;
	} elsif (!defined $rec) {
	    die "piggybacked record was not available";
	}

	$out2->appendToLastItem(" got record");
	$rs->destroy();
    }

    # Of the other fields in the "searchable" profile, displayName,
    # serviceProvider, opacVendor, categories, and comment and
    # human-readable only, I don't know what sru and sourceType are,
    # and I can't see a way to test urlRecipe piggyback and apduLog.

    $conn->destroy();
    $out->item("Closed connection to Z39.50 server");
    return undef;
}
</%perl>
</%def>
<%def maybe_set_attribute>
<%args>
$out
$obj
$key
$value
</%args>
<%perl>
{
    if (defined $value) {
	$obj->option($key, $value);
	$out->item("Set $key to '" . encode_entities($value) . "'");
    } else {
	$out->item("(No setting for $key -- no problem)");
    }
}
</%perl>
</%def>
