<%args>
$copyFromId
$name
$realm
</%args>
<%perl>
die "copyFromId not defined" if !defined $copyFromId;
my $admin = $m->notes("admin");
my $user = $m->comp("/mc/utils/user.mc", require => 1) or return;
my $adminRealm = $user->field("identityId");
my $adminTorus = $admin->torus();
my $record = $adminTorus->recordByArgs(realm => $adminRealm, id => $copyFromId)
    or die "no record '$copyFromId' for realm '$adminRealm'";
print "   <h2>Copying Library '", encode_entities($record->displayName()), "'</h2>\n";

if ($realm eq "") {
    # This must behave the same as the JavaScript function maybeFill()
    $realm = lc($name);
    $realm =~ s/[^a-z0-9]/_/ig;
}

my $searchableAdmin = new Masterkey::Admin("searchable");
my $searchableTorus = $searchableAdmin->torus();
# This torus is used only to probe for the existence of realms

my $newRealm;
if ($realm =~ /^\d+$/) {
    # If an exact numerical realm ID is given, don't mess with it.
    # The Library of Texas needs this special case: see SUP-535
    eval {
	$searchableTorus->records($realm, undef, undef, 0, undef, 0, 1);
    }; if (!$@) {
	die "numeric realm '$realm' already exists";
    } elsif ("$@" != /404/) {
	die $@;
    }
    # Error 404, which is what we want: realm doesn't exist yet
    $newRealm = $realm;
    print "   <p>Using specified numeric destination realm '$realm'.</p>\n";
} else {
    # Find a new realm that can be used without collisions.  Start
    # with the one suggested by the user; if that doesn't work, then
    # keep increasing the trailing numeric part (if any; otherwise
    # start at 2) until a free realm is found.  ### There is an
    # obvious race condition here, but I assume that concurrent
    # consortium-level administrators cloning the same library
    # simultaneously will be rare enough that we don't need to worry
    # about it.

    $realm =~ s/(\d*)$//;
    my $suffix = $1;
    my $count = 0;
    while ($count < 100) {
	eval {
	    # We really want 0 records, but for now work around bug #4503
	    $newRealm = ($realm . $suffix) || "0";
	    my $rs = $searchableTorus->records($newRealm, undef, undef, 0, undef, 0, 1);
	    print "   <p>Realm '$newRealm' is occupied (", $rs->alln(), " targets)</p>\n";
	}; if ($@ && "$@" =~ /404/) {
	    last;
	} elsif ($@) {
	    die "$@";
	}

	$suffix++;
	$count++;
    }

    die "can't find a free realm even after $count tries!"
	if $count == 100;
    print "   <p>Destination realm '$newRealm' is free.</p>\n";
}

use Data::Dumper;

# Create administrator record
my $adminRecordId = $adminTorus->add(0, $adminRealm, undef, $user,
				     identityId => $newRealm,
				     userName => $newRealm,
				     password => "XXXXXXXX",
				     superuser => $record->field("superuser"),
				     displayName => $name);
die "can't make new administrator record" if !defined $adminRecordId;
print "   <p>Made administrator record '$adminRecordId'.</p>\n";

my $debug = 0;
foreach my $ref ([ "searchable", "searchable" ],
		 [ "lcat",        "category" ]) {
    my($tab, $type) = @$ref;
    my $oldRealm = $record->field("identityId");

    # Create realm to hold copied records
    my $admin = new Masterkey::Admin($tab);
    my $torus = $admin->torus();

    my $torusProperties = $torus->properties($oldRealm);
    my $autoInherit = $torusProperties->autoInherit();
    my $newRealmUrl = $torus->ws() . ".$newRealm/";
    $adminTorus->create_realm($newRealmUrl, $type, $autoInherit);
    print "   <p>Made '$type' realm for '$tab' tab";
    print " (with autoInherit)" if $autoInherit;
    print "</p>\n";

    # Copy parents from old realm to new.  Note ID->URL map
    my(%oldParent2url, %url2newParent);

    print "   <p>Copying $type masters:</p>\n";
    print "   <ul>\n";
    my @masters;
    eval {
      @masters = $torus->masters($oldRealm);
    };
    
    if ($@) {
        # mostly harmless, not all libraries have a master record
	print "<pre>" . $@ . "</pre>" if $debug >= 2;
    } else {
	foreach (my $i = 0; $i < @masters; $i++) {
	    my $master = $masters[$i];
	    my $label = $master->label();
	    my $matchQuery = $master->matchQuery();

	    my %data;
	    foreach my $name ($master->fields("master-override")) {
		next if $name eq "realm";
		$data{$name} = $master->field($name, "master-override");
	    }

	    $torus->addMaster($newRealm, $label, $matchQuery, {}, %data);
	    print "    <li>", encode_entities($label || "[UNLABELLED]"), "</li>\n";
	}
    }
    print "   </ul>\n";

    print "   <p>Copying $type parents:</p>\n";
    print "   <ul>\n";
    my @parents = $torus->parents($oldRealm);
    foreach (my $i = 0; $i < @parents; $i++) {
	my $parent = $parents[$i];
	$oldParent2url{$parent->id()} = $parent->url();
	my $id = $torus->addParent($newRealm, $parent->name(), $parent->priority(), $parent->refreshAfter(), $parent->url);
	$url2newParent{$parent->url()} = $id;
	print "    <li>", encode_entities($parent->name), "</li>\n";
    }
    print "   </ul>\n";

    # Copy records from old realm to new.  Tweak worldIds on the way through
    print "   <p>Copying $type records from realm '", encode_entities($oldRealm), "'.</p>\n";
    print "   <ul>\n";
    my $rs = $torus->records($oldRealm);
    RECORD: foreach (my $i = 0; $i < $rs->alln(); $i++) {
	my $record = $rs->record($i);
	my %data;
	my $worldId = undef;
	my $suffix = "";

	# copy only local records, not from original or autoInherit
	if (!($record->field("creationDate", "override") || $record->field("lastModified", "override"))) {
	    my $worldId = $record->field("worldId");
	    if (defined $worldId && $worldId eq $record->field("id")) {
		# Identical id/worldId AND no creationDate is an autoInherited record
		next RECORD;
	    } else {
		# Very old explicit overrides have no creationDate, but worldId differs
		$suffix = " [OLD RECORD]";
	    }
	}

	foreach my $key ($record->fields("override")) {
	    my $val = $record->field($key, "override");
	    if ($key eq "worldId") {
		### Not good enough -- the prefix part of the worldId
		#   will in general refer to a parent that has a
		#   different ID in the source realms to that
		#   allocated in the destination realm.
		my($prefix, $remainder) = ($val =~ /(.*?)\.(.*)/);
		if (!defined $prefix || $prefix eq "") {
		    warn "invalid worldId '$val'";
		    print("    <li class='error'>Not copying ", encode_entities($record->displayName()),
			  ": bad worldId '$val'</li>\n");
		    next RECORD;
		}
		my $url = $oldParent2url{$prefix} or
		    die "can't map old parent ID '$prefix' for worldId '$val'";
		my $newId = $url2newParent{$url} or
		    die "can't map parent url '$url'";
		$worldId = "$newId.$remainder";
	    } elsif ($key eq "id" || $key eq "realm") {
		# Just ignore it
	    } else {
		$data{$key} = $val;
	    }
	}
	my $id = $torus->add(0, $newRealm, $worldId, $user, %data);
	print "    <li>", encode_entities($record->displayName()), "$suffix -> $id</li>\n";
    }
    print "   </ul>\n";
}

print qq[   <a href="single.html?id=$adminRecordId">Go to ], encode_entities($name), "</a>\n";
</%perl>
