package Masterkey::Admin::Session;

use 5.008;
use strict;
use warnings;

use Fcntl;   # For O_RDWR, O_CREAT, etc.
use SDBM_File;
use FreezeThaw;

sub new {
    my $class = shift();

    my $chars = join("", "A".."Z", "a".."z", "0".."9", "+", "/");
    my $cookie = "";
    foreach my $i (1..12) {
	$cookie .= substr($chars, int(rand()*64), 1);
    }

    return bless {
	cookie => $cookie,
    }, $class;
}

sub cookie { shift()->{cookie} }
sub user_id { shift()->{user_id} }
sub dest { shift()->{dest} }

sub find {
    my $this = shift();
    my($cookie) = @_;

    my $val;
    _with_dbfile(0, sub {
	my($href) = @_;
	$val = $href->{$cookie};
    });

    return undef if !defined $val;
    my($session) = FreezeThaw::thaw($val);
    return $session;
}

# Returns the number of fields modified, dies on error
sub update {
    my $this = shift();
    my(%data) = @_;

    my $count = 0;
    foreach my $key (keys %data) {
	if (!defined $this->{$key} || $data{$key} ne $this->{$key}) {
	    $this->{$key} = $data{$key};
	    $count++;
	}
    }

    if ($count > 0) {
	_with_dbfile(1, sub {
	    my($href) = @_;
	    my $cookie = $this->cookie();
	    $href->{$cookie} = FreezeThaw::freeze($this);
	});
    }

    return $count
}

sub delete {
    my $this = shift();

    _with_dbfile(1, sub {
	my($href) = @_;
	my $cookie = $this->cookie();
	delete $href->{$cookie};
    });
}

# Accepts a list of candidate links, each of them an array-reference
# whose 0th element is a session identifier. Returns a new list
# consisting of those elements for which the session identifier
# corresponds to a session that actually exists.
#
sub filter_links {
    my(@list) = @_;
    my @res;

    _with_dbfile(0, sub {
	my($href) = @_;
	foreach my $ref (@list) {
	    my $sessid = $ref->[0];
	    push @res, $ref if exists $href->{$sessid};
	}
    });

    return @res;
}

sub _with_dbfile {
    my($readWrite, $callback) = @_;
    # For some reason, O_WRONLY|O_CREAT fails with ENOENT
    my $flags = $readWrite ? (O_RDWR|O_CREAT) : O_RDONLY;

    my $tag = $ENV{MAsessiontag};
    if (!defined $tag) {
	my $dir = $ENV{MAconfigdir} or
	    die "no MAsessiontag or MAconfigdir defined in environment";
	my @comp = split('/', $dir);
	for (my $i = @comp-1; $i >= 0; $i--) {
	    $tag = $comp[$i];
	    last if $tag ne "admin" && $tag ne "mkadmin";
	}
    }
    my $dbfile = "/tmp/mkadmin-sessions-$tag.sdbm";

    my %h;
    tie(%h, "SDBM_File", $dbfile, $flags, 0666)
	or die "Couldn't write SDBM file '$dbfile': $!";

    &$callback(\%h);

    untie %h;
    
}

1;
