use Test::More tests => 2;

BEGIN {
    use_ok('Masterkey::Admin');
}

use Encode;    # For encode_utf8() and decode_utf8()
use URI::Escape qw(uri_escape_utf8 uri_unescape);
use HTML::Entities;    # For encode_entities()

use strict;
use warnings;

chomp(my $pwd = `pwd`);
$ENV{MAconfigdir} ||= "$pwd/config/system/";

my $admin = Masterkey::Admin->new();

isnt( $admin, undef, "admin obj test" );

my $query = "";
my $torus = $admin->torus();

__DATA__;
isnt( $torus, undef, "torus obj test" );

my $realm = "### what should we use for this test?";
my $rs = $torus->world($realm, $query) if $torus;
my $record = $rs->records();
isnt( @$records, 0, "read records from torus" );

1;

__DATA__;
use Data::Dumper; print Dumper($admin);

