###############################################################
#
# wrapper to convert CGI->parameters() to unicode strings
#
# see also: http://www.cybaea.net/Blogs/Mason-utf-8-clean.html
#
# enable in /etc/apache2/sites-enabled/mkc-admin with:
#
#  PerlAddVar MasonPlugins "MasonX::Plugin::UTF8"
#

package MasonX::Plugin::UTF8;
use base qw(HTML::Mason::Plugin);
use Encode qw(decode);

use warnings;
use strict;

sub start_request_hook {
    my ( $self, $context ) = @_;

    my $args_ref = $context->args();

    foreach my $arg ( @{$args_ref} ) {
        if ( !Encode::is_utf8($arg) ) {
            $arg = decode( 'UTF-8', $arg, Encode::FB_CROAK );
        }
    }

    return;
}

1;

