package Masterkey::Admin::Master;

use strict;
use warnings;
use Scalar::Util;
use Masterkey::Admin::Record;

use vars qw(@ISA);
@ISA = qw(Masterkey::Admin::Record);

sub new {
    my $class = shift();
    my($torus, $x, $using_XML_LibXML_Simple) = @_;

    my $y = $x->{layer}->[0];
    my $id = delete $y->{id};
    if (ref($id)) {
	# We're using regular XML::Simple, which yields and array
	$id = $id->[0];
    }

    my $label = delete $y->{label};
    my $matchQuery = delete $y->{matchQuery};

    my $this = new Masterkey::Admin::Record($torus, 0, $x, $using_XML_LibXML_Simple);
    $this->{id} = $id;
    $this->{label} = $label;
    $this->{matchQuery} = $matchQuery;
    bless $this, $class;

    return $this;
}

sub torus { shift()->{torus} }
sub id { shift()->{id} }
sub label { shift()->{label} }
sub matchQuery { shift()->{matchQuery} }

1;
