#!/usr/bin/perl

use utf8;
use Test::More;
use CGI;

use lib './lib';
use MasonX::Plugin::UTF8;
use Encode;

use strict;
use warnings;

my $args = [ "foo", "München", "Muenchen4" ];

plan tests => 3 * scalar(@$args);

################################################
# fake context object for testing
#
package context;

sub new {
    my $class = shift;
    my %args  = @_;

    my $self = {%args};
    bless $self, $class;

    return $self;
}

sub args {
    return $args;
}

1;    # end of class
##################################################
package main;

# to unicode string
MasonX::Plugin::UTF8::start_request_hook( "dummy", new context );

foreach my $string (@$args) {
    is( Encode::is_utf8($string), 1, "string is utf8" );
}

# convert back to octets
foreach my $string (@$args) {
    $string = encode( "UTF-8", $string );
    is( Encode::is_utf8($string), '', "string is octets" );
}

# to unicode string
MasonX::Plugin::UTF8::start_request_hook( "dummy", new context );

foreach my $string (@$args) {
    is( Encode::is_utf8($string), 1, "string is utf8" );
}

1;

__DATA__;
