use strict;
use warnings;
use Test::More tests => 4;

# Tests that we can translate Torus XML into the same record
# structures whether we're using XML::Simple (as previously) or the
# not-really-drop-in replacement XML::LibXML::Simple (which we want
# for performance reasons).

use XML::Simple;
use XML::LibXML::Simple ();

BEGIN {
    use_ok('Masterkey::Admin');
    use_ok('Masterkey::Admin::Torus');
    use_ok('Masterkey::Admin::Record');
};

chomp(my $pwd = `pwd`);
$ENV{MAconfigdir} ||= "$pwd/config/system";
my $admin = new Masterkey::Admin("searchable");
my $torus = $admin->torus();
my $text = join('', <DATA>);

my $xml1 = XMLin($text, ForceArray => 1, KeyAttr => []);
my $rec1 = new Masterkey::Admin::Record($torus, 0, $xml1);
my $render1 = render($rec1);

my $xs2 = XML::LibXML::Simple->new();
my $xml2 = $xs2->XMLin($text, ForceArray => 1, KeyAttr => []);
my $rec2 = new Masterkey::Admin::Record($torus, 0, $xml2, 1);
my $render2 = render($rec2);

is($render2, $render1, "comparison of parser output");

sub render {
    my($rec) = @_;

    use Data::Dumper;
    $Data::Dumper::Indent = 1;
    $Data::Dumper::Sortkeys = 1;

    local $rec->{torus} = undef;
    return Dumper($rec);
}


__DATA__
<?xml version="1.0" encoding="UTF-8"?>
<record URI="http://mkhome:8080/torus/searchable/records/admin/A.local-3-73" type="searchable">
  <layer xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" name="original" xsi:type="searchableTypeLayer">
    <authentication>xxx.xxx.xxx/xxx@FT-LINKS</authentication>
    <cclmap_au>1=1004 s=al</cclmap_au>
    <cclmap_date>1=30 r=r</cclmap_date>
    <cclmap_isbn>1=7</cclmap_isbn>
    <cclmap_su>1=21 s=al</cclmap_su>
    <cclmap_term>1=1016 s=al</cclmap_term>
    <cclmap_ti>1=4 s=al</cclmap_ti>
    <comment>Note the @FT-LINKS required in the authentication field -- otherwise, full-text links won't be included.</comment>
    <displayName>EBSCO</displayName>
    <elementSet>F</elementSet>
    <piggyback>1</piggyback>
    <queryEncoding>MARC-8</queryEncoding>
    <recordEncoding>MARC-8</recordEncoding>
    <requestSyntax>MARC21</requestSyntax>
    <serviceProvider>EBSCO</serviceProvider>
    <transform>marc21.xsl</transform>
    <zurl>zgw.ebscohost.com/DBNAME</zurl>
    <categories>id_subscription</categories>
    <id>A.local-3</id>
    <identity>world</identity>
  </layer>
  <layer xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" name="override" xsi:type="searchableTypeLayer">
    <worldId>A.local-3</worldId>
    <displayName>Christian Periodical Index</displayName>
    <zurl>zgw.ebscohost.com/33H</zurl>
    <id>A.local-3-73</id>
    <identity>admin</identity>
  </layer>
  <layer xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" name="final" xsi:type="searchableTypeLayer">
    <authentication>xxx.xxx.xxx/xxx@FT-LINKS</authentication>
    <cclmap_au>1=1004 s=al</cclmap_au>
    <cclmap_date>1=30 r=r</cclmap_date>
    <cclmap_isbn>1=7</cclmap_isbn>
    <cclmap_su>1=21 s=al</cclmap_su>
    <cclmap_term>1=1016 s=al</cclmap_term>
    <cclmap_ti>1=4 s=al</cclmap_ti>
    <comment>Note the @FT-LINKS required in the authentication field -- otherwise, full-text links won't be included.</comment>
    <displayName>Christian Periodical Index</displayName>
    <elementSet>F</elementSet>
    <piggyback>1</piggyback>
    <queryEncoding>MARC-8</queryEncoding>
    <recordEncoding>MARC-8</recordEncoding>
    <requestSyntax>MARC21</requestSyntax>
    <serviceProvider>EBSCO</serviceProvider>
    <transform>marc21.xsl</transform>
    <zurl>zgw.ebscohost.com/33H</zurl>
    <categories>id_subscription</categories>
    <id>A.local-3-73</id>
    <identity>admin</identity>
    <worldId>A.local-3</worldId>
  </layer>
</record>
