<%args>
$file => "/tmp/affiliation.csv"
$debug => 0
</%args>
<%once>
use Masterkey::Admin::Report;
use File::Temp;
</%once>


<%perl>
my $fh = File::Temp->new(TEMPLATE => "$file.XXXXXXXX", UNLINK => 0);
my $file_tmp = $fh->filename;

warn "Re-generate '$file_tmp'\n" if $debug;

if (!defined $fh) {
    die "open $file_tmp: $!\n";
}
binmode $fh, ":utf8";

$m->comp("/mc/setup.mc");
my $admin = $m->notes("admin");
my $user = $m->comp("/mc/utils/user.mc") or return;

my $report = new Masterkey::Admin::Report();
my $rs = $report->itorus()->records("admin", undef, undef, 1);
my $identities = $rs->records();
### Should we uniquify on realm?
my @identities = sort { $a->displayName() cmp $b->displayName() } @$identities;

foreach my $identity (@identities) {
    my $name = $identity->displayName();
    my $realm = $identity->field("identityId");
    print $fh $report->row($realm, $name);
}

rename($file_tmp, $file) or die "rename $file_tmp -> $file: $!\n";

</%perl>
