<%perl>
my $domain2tab = $m->comp("/mc/domain2tab.mc");
my $admin = $m->notes("admin");
my $domain = $admin->conf("authDomain");
my %cookies = Apache2::Cookie->fetch($r);

if (!$ENV{MAnewurls}) {
    foreach my $key (sort keys %cookies) {
	if ($key =~ s/^session-//) {
	    next if $key eq $domain;
	    my $ref = $domain2tab->{$key} or die "unknown session domain '$key'";
	    my($tab, $level) = @$ref;
	    print qq[<a href="../$tab/"> Return to $level view</a> |];
	}
    }
    return;
}


my @links;
foreach my $key (sort keys %cookies) {
    my $cookie = $cookies{$key};
    if ($key =~ s/^session-//) {
	my $identityId;
	if ($key !~ /-/) {
	    warn "ignoring left-over old-style cookie '$key'";
	    next;
	}

	$key =~ s/-(.*)//;
	$identityId = $1;
	next if $key eq $domain;

	warn "found link to identityId '$identityId' for domain $domain";
	my $ref = $domain2tab->{$key} or die "unknown session domain '$key'";
	my($tab, $level) = @$ref;
	my $sessid = $cookie->value();
	push @links, [ $sessid, $identityId, $tab, $level ];
    }
}


@links = Masterkey::Admin::Session::filter_links(@links);
my %levels;
foreach my $ref (@links) {
    my($sessid, $identityId, $tab, $level) = @$ref;
    push @{ $levels{$level} }, $ref;
}

foreach my $level (sort keys %levels) {
    print "Return to $level as ";
    my $list = $levels{$level};
    for (my $i = 0; $i < @$list; $i++) {
	my $ref = $list->[$i];
	my($sessid, $identityId, $tab, $level) = @$ref;
	print ", " if $i > 0;
	print qq[<a class="ul" href="../../$identityId/$tab/">$identityId</a>];
    }
    print " |";
}
</%perl>
