package Masterkey::Admin::Profile;

use strict;
use warnings;
use Scalar::Util;
use IO::File;

sub new {
    my $class = shift();
    my($config, $pname) = @_;

    my $this = bless {
	config => $config,
	fields => [],
	mandatory => {},
    }, $class;
    Scalar::Util::weaken($this->{config});

    my $d2 = $config->value("profilePath") || ".";
    (my $fh) = $config->_open_file("$d2/$pname.torus-profile", 0);

    while (my $line = $fh->getline()) {
	chomp($line);
	$line =~ s/#.*//;
	$line =~ s/\s+$//;
	if ($line ne "") {
	    my($key, $value) = ($line =~ /(.*?)\s+(.*)/);
	    if (defined $value && lc($value) eq "mandatory") {
		push @{ $this->{fields} }, [ $key, 1 ];
	    } else {
		push @{ $this->{fields} }, [ $line, 0 ];
	    }
	}
    }

    foreach my $ref (@{ $this->{fields} }) {
	my($key, $mandatory) = @$ref;
	$this->{mandatory}->{$key} = $mandatory;
    }

    $fh->close();
    return $this;
}

sub fields { @{ shift()->{fields} } }

sub mandatory {
    my $this = shift();
    my($field) = @_;

    return $this->{mandatory}->{$field};
}

1;
