package Masterkey::Admin::Properties;

use strict;
use warnings;
use Scalar::Util;

sub new {
    my $class = shift();
    my($torus, $realm, $x) = @_;

    # See "Realm Resource" at http://www.indexdata.com/torus/protocol.html
    my $this = bless {
	torus => $torus,
	realm => $realm,
	name => $x->{name},
	type => $x->{type},
	matchKey => $x->{matchKey},
	autoInherit => $x->{autoInherit} ? 1 : 0,
    }, $class;

    Scalar::Util::weaken($this->{torus});
    return $this;
}

sub name { shift()->{name} }
sub type { shift()->{type} }
sub matchKey { shift()->{matchKey} }
sub autoInherit { shift()->{autoInherit} }

sub setAutoInherit {
    my $this = shift();
    my($newval) = @_;

    $this->{autoInherit} = $newval;
}

sub update {
    my $this = shift();

    return $this->{torus}->setProperties($this->{realm},
					 $this->{name},
					 $this->{type},
					 $this->{matchKey},
					 $this->{autoInherit});
}

1;
