package Masterkey::Admin::Record::Layer;

use strict;
use warnings;
use Scalar::Util;

use Masterkey::Admin::LogLevel;

sub new {
    my $class = shift();
    my($record, $x, $using_XML_LibXML_Simple) = @_;

    my $this = bless {
	record => $record,
	layer => delete $x->{name},
	fields => {},
    }, $class;

    if ($this->record()->torus()->admin()->option("loglevel") &
	Masterkey::Admin::LogLevel::LAYER) {
	# It's naughty to peek at the loglevel
	print $this->record()->torus()->log(Masterkey::Admin::LogLevel::LAYER,
				$this->record()->torus()->admin()->dump($x));
    }

    Scalar::Util::weaken($this->{record});
    foreach my $key (keys %$x) {
	use Data::Dumper;
	$this->_set_field($key, $x, $using_XML_LibXML_Simple);
    }

    return $this;
}


sub _set_field {
    my $this = shift();
    my($key, $x, $using_XML_LibXML_Simple) = @_;

    if ($using_XML_LibXML_Simple) {
	$this->_set_field_LibXML($key, $x);
    } else {
	$this->_set_field_regular($key, $x);
    }
}


sub _set_field_LibXML {
    my $this = shift();
    my($key, $x) = @_;
    my $val = $x->{$key};

    if (ref($val) eq "ARRAY" && @$val == 1 &&
	ref $val->[0] eq "HASH" && %{ $val->[0] } == 0) {
	# Revolting special case: for some reason
	# XML::LibXML::Simple represents an empty element <foo/>
	# as an array containing an empty hash, [{}].
	$this->{fields}->{$key} = "";
    } elsif (ref($val) eq "ARRAY") {
	# Any non-ARRAYs are attributes, eg. xsi:type.  Ignore them.
	### I think this never happens for _set_field_LibXML()
	$this->{fields}->{$key} = $val->[0];
	warn "$key set from array to ", $val->[0] if $key eq "comment";
    } else {
	# Frustrating ... although XML::LibXML::Simple is supposed
	# to be a drop-in replacement for XML::Simple, it produces
	# notably different XML -- in particular, content is not
	# wrapped in arrays even when ForceArray=>1 is specified,
	# so the only way we can determine which items are
	# attributes (to be ignored) and which are elements (to be
	# retained) is by knowing in advance what the names of the
	# attributes are.
	#
	# Truly appalling hack follows: due to an earlier bug (fixed
	# in the clause above), some empty field have got populated
	# with strings of the form "HASH(0x23fc33a0)".  We work around
	# this by spotting such fields and not setting a value for
	# them.
	return if $val =~ /^HASH\(0x[0-9a-f]+\)$/;
	if ($key ne "xsi:type" &&
	    $key ne "xmlns:xsi") {
	    $this->{fields}->{$key} = $val;
	}
    }
}


sub _set_field_regular {
    my $this = shift();
    my($key, $x) = @_;

    if (ref($x->{$key}) eq "ARRAY") {
	# Any non-ARRAYs are attributes, eg. xsi:type.  Ignore them.
	my $val = $x->{$key}->[0];
	# Same ghastly hack as before
	return if $val =~ /^HASH\(0x[0-9a-f]+\)$/;
	$this->{fields}->{$key} = $val;
    } else {
	warn "no case $key" if $key eq "comment";
    }
}

sub record { shift()->{record} }
sub layer { shift()->{layer} }

sub fields {
    my $this = shift();

    return sort keys %{ $this->{fields} };
}

sub field {
    my $this = shift();
    my($name) = @_;

    return $this->{fields}->{$name};
}

1;
