use Test::More tests => 5;

BEGIN {
    use_ok('Masterkey::Admin');
};

chomp(my $pwd = `pwd`);
$ENV{MAconfigpath} ||= "$pwd/../mk2-config-newdemo/admin/mkadmin:$pwd/config/system";
$ENV{SERVER_NAME} ||= "mk2.indexdata.com";

use strict;
use warnings;

my $admin = new Masterkey::Admin("searchable");
my $realm = "mike";
my $query = "museum";

my $url = $admin->torus()->recordsURIbyArgs(realm => $realm, query => $query);
is($url, "http://mk2.indexdata.com/torus2/searchable.$realm/records/?query=$query", "generated correct Torus URL");

my $rs = $admin->torus()->records($realm, $query);
ok(defined $rs, "generated result set");
my $recs = $rs->records();
my $n = @$recs;
ok($n >= 1, "found $n records (> 0)");
foreach my $i (1..$n) {
    my $rec = $recs->[$i-1];
}
ok(1, "retrieved records");
