<%args>
$file => "/tmp/categories.csv"
$debug => 0
</%args>
<%once>
use Masterkey::Admin::Report;
use File::Temp;
</%once>

<%perl>
my $fh = File::Temp->new(TEMPLATE => "$file.XXXXXXXX", UNLINK => 0);
my $file_tmp = $fh->filename;

warn "Re-generate '$file_tmp'\n" if $debug;

if (!defined $fh) {
    die "open $file_tmp: $!\n";
}
binmode $fh, ":utf8";

$m->comp("/mc/setup.mc");
my $admin = $m->notes("admin");
my $user = $m->comp("/mc/utils/user.mc") or return;

my $report = new Masterkey::Admin::Report();
my $rs = $report->ctorus()->records("admin", undef, undef, 1);
my $categories = $rs->records();
my @categories = sort { $a->displayName() cmp $b->displayName() } @$categories;

foreach my $category (@categories) {
    my $name = $category->displayName();
    my $catId = $category->field("categoryId");
    if (!defined $catId || $catId eq "") {
        warn "ignoring category '$name' with no category Id";
        print $fh $report->row($name, "[NO CATEGORY ID]");
        next;
    }
    print $fh $report->row($name, "");
    my $rs = $report->gtorus()->records("admin", qq[categories="$catId"]);
    my $list = $rs->records();
    my @list = sort { lc($a->displayName()) cmp lc($b->displayName()) } @$list;
    foreach my $searchable (@list) {
        print $fh $report->row("", $searchable->displayName());
    }
}

rename($file_tmp, $file) or die "rename $file_tmp -> $file: $!\n";

</%perl>
