<%args>
$debug => undef
$title
$component
</%args>
<%once>
use Encode; # For encode_utf8() and decode_utf8()
use URI::Escape qw(uri_escape_utf8 uri_unescape);
use HTML::Entities; # For encode_entities()
use Masterkey::Admin::Utils qw(utf8param);
use CGI;
use Apache2::Cookie; # For the use of link-to-other-level.mc
#use MIME::QuotedPrint; # Generating debugging output with encode_qp($utfString)

</%once>
<%perl>
my $q = CGI->new($r);
$m->notes('q' => $q);
$r->content_type("text/html; charset=utf-8");
$m->comp("/mc/setup.mc");
my $admin = $m->notes("admin");

# $type and $pluralType can be substituted into various places
my $type = $admin->conf("type");
my $tabTitle = $admin->conf("title");
my $pluralType = $type;
if ($pluralType =~ /y$/) {
    $pluralType =~ s/y$/ie/;
}
$pluralType .= "s";
$m->notes(pluralType => $pluralType);

# Generate the text of the client area before emitting the framework:
# this allows it to affect the state, so that for example a login or
# logout $component can set or unset $user.
my $text;
eval {
    $text = $m->scomp($component, %ARGS);
}; if ($@ && $@ =~ /Bad parent response/) {
    $@ =~ s/Stack:.*//s;
    $text = "<p class='error'>$@</p>";
    $text .= "<p>It looks like the Torus is configured with a bad parent. ";
    $text .= "<a href='parents.html'>Fix it here</a></p>";
} elsif ($@) {
    $text = $admin->exception2error($@, $debug);
}

my $tabName = $m->notes("tabName");
my $user = $m->notes("user");
my $ucType = ucfirst($type);
my $ucPluralType = ucfirst($pluralType);

$title =~ s/%{type}/$ucType/g;
$title =~ s/%{pluralType}/$ucPluralType/g;
my $pageTitle = encode_entities($admin->conf("siteTitle"));
$pageTitle .= ': ' . encode_entities($tabTitle) if $tabTitle;
$pageTitle .= ': ' . encode_entities($title) if !$admin->conf("disablePageTitle");
my $icon = $admin->siteConf("siteIcon");
</%perl>
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html 
     PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
 <head>
  <title><% $pageTitle %></title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <link rel="stylesheet" type="text/css" href="basic.css"/>
% if (defined $icon) {
  <link rel="icon" type="image/vnd.microsoft.icon" href="<% $icon %>">
  <link rel="shortcut icon" type="image/x-icon" href="<% $icon %>">
% }
% if ($admin->conf("disableMenu")) {
  <link rel="stylesheet" type="text/css" href="nomenu.css"/>
% }
  <link rel="stylesheet" type="text/css" href="site.css"/>
  <script type="text/javascript" src="changecss.js"></script>
  <script type="text/javascript" src="utils.js"></script>
 </head>
 <body>
  <div id="prologue">
<%perl>
my $h1 = '<a href="/">' . encode_entities($admin->conf("siteTitle")) . '</a>';
if ($tabTitle) {
    if (!$admin->conf("disableHomeLink")) {
	$h1 .= qq[: <a href="./">] . encode_entities($tabTitle) . qq[</a>];
    } else {
	$h1 .= ': ' . encode_entities($tabTitle);
    }
}
$h1 .= ': ' . encode_entities($title) if !$admin->conf("disablePageTitle");
</%perl>
   <h1><% $h1 %></h1>
  </div>
  <div id="usermenu">
% if ($user) {
   <div id="umleft">
% my($pre, $post);
% if (!$admin->conf("disableUserLink")) {
%    ($pre, $post) = (qq[<a href="user.html">], qq[</a>]);
% } else {
%    ($pre, $post) = ("", "");
% }
    <% $pre %><% encode_entities($user->displayName()) %><% $post %>
% if (!$admin->conf("disableRealmDisplay")) {
    (<tt><% encode_entities($user->field("identityId")) %></tt>)
% }
% if (!$admin->conf("disableUserLinks")) {
    |
    <a href="details.html"><% $admin->caption("details", "Details") %></a>
    |	
    <a href="password.html">Password</a>
% }
   </div>
% }
   <div id="umright">
<& link-to-other-level.mc &>
% if ($user) {
    <a href="logout.html">Logout</a>
% } else {
    <a href="login.html">Login</a>
% }
% my $helpPage = $admin->conf("helpPage");
% if ($helpPage) {
    |	
    <a href="<% encode_entities($helpPage) %>">Help</a>
% }
   </div>
  </div>
  <table border="0" id="tabs">
   <tr>
<%perl>
my $cfg = $admin->configObject();
</%perl>
% for (my $i = 1;; $i++) {
%     my $name = $cfg->value("tab.$i.caption") or last;
%     next if $name =~ /^\[/; # Omit obsolete library/consortium-level tabs
%     # Recognise new property only if old, deprecated one is missing
%     my $tag = $cfg->value("tab.$i.subsite") || $cfg->value("tab.$i.tab") || "";
%     if ($tag eq $tabName) {
    <td class="active-tab">
     <span class="active-inner">
      <a href="../<% $tag %>/"><% encode_entities($name) %></a>
     </span>
    </td>
%     } else {
    <td class="inactive-tab">
     <span class="inactive-inner">
      <a href="../<% $tag %>/"><% encode_entities($name) %></a>
     </span>
    </td>
%     }
% }
    <td class="inactive-tab">
     <% "&nbsp;" x 16 %>
    </td>
   </tr>
  </table>
% my $iframe = $admin->conf("iframeURL");
% if (defined $iframe) {
% print qq[<iframe src="$iframe" width="100%" frameborder="0"></iframe>\n];
% return;
% }
  <div id="menu">
% if (!$admin->conf("noMenuItems")) {
% my $menuHTML = $admin->conf("menuHTML");
% if ($menuHTML) {
<% $menuHTML %>
% } else {
% if (!$admin->conf("disableHomeLink")) {
   <p><a href="./"><b>Home</b></a><br/></p>
% }
% if (!$admin->conf("noworld")) {
   <p><% $admin->caption("allObjects", "All $pluralType") %></p>
   <ul class="tight">
    <li><a href="find.html"><% $admin->caption("find", "Find") %></a></li>
    <li><a href="all.html"><% $admin->caption("list", "List") %></a></li>
   </ul>
% }
<& /mc/menuitems.mc, category => "menu" &>
% if ($user) {
   <p><% $admin->caption("myObjects", "My $pluralType") %></p>
   <ul class="tight">
    <li><a href="findmy.html"><% $admin->caption("find", "Find") %></a></li>
    <li><a href="my.html"><% $admin->caption("list", "List") %></a></li>
    <li><a href="new.html"><% $admin->caption("new", "New") %></a></li>
   </ul>
<& /mc/menuitems.mc, category => "usermenu" &>
% }
% } # END menuHTML
% if ($admin->conf("realm") && !$admin->conf("noworld") && !$admin->conf("disableManageParents") &&
%     defined $user && $user->field("superuser")) {
   <hr/>
   <a href="parents.html">Manage Parents</a>
   <br/>
   <a href="masters.html">Manage Masters</a>
% }
   <span id="facets"></span>
   <br/>
% } # END noMenuItems
% if (defined $user && $user->field("superuser")) {
   <p>
    <a href="http://validator.w3.org/check?uri=referer"><img
	src="valid-xhtml10.png"
	alt="Valid XHTML 1.0 Strict" height="31" width="88" /></a>
    <br/>
    <a href="http://jigsaw.w3.org/css-validator/"><img
	src="vcss.png"
	alt="Valid CSS!" height="31" width="88" /></a>
   </p>
% }
  </div>
  <div id="main">
<% $text %>
  </div>
  <div id="epilogue">
   <a href="http://indexdata.com/">Powered by Index Data</a>
  </div>
 </body>
</html>
