<%args>
$date
$date_range_selected
$date_aliases
</%args>
<%perl>

use Time::Piece;

my $year_begin = 2010;
my $year_period = 30;
my @month = qw/Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec/;

my $t = localtime;
my $t_year = $t->year;
my $t_month = $t->_mon;
my $t_day = $t->day_of_month;

my @date = (
    ["today", "Today"],
    ["yesterday", "Yesterday"],
    ["7days", "7 days"],
    ["month", "Month"],
    ["last_month", "Last Month"],
    ["last_quarter", "Last Quarter"],
    ["last_last_quarter", "Last Last Quarter"],
    ["quarter", "Quarter"],
    ["anniversary_quarter", "Anniversary Quarter"],
    ["all_time", "All Time"],
);

my $date_range_selected_alias = $date_range_selected eq 'alias' ? 'checked="checked"' : "";
my $date_range_selected_custom = $date_range_selected eq 'custom' ? 'checked="checked"' : "";
my %date_aliases = map { $_ => 1 } split /\s+/, $date_aliases;
</%perl>


<b>Date range:</b>
<table id="date" cellspacing="0" cellpadding="0">
<tr>
<td><input type="radio" id="simpleDate" name="dateRange.dateRangeType" <% $date_range_selected_alias %>
value="simple" id="simpleDate"></td>
<td style="text-align:left;">
<table>
<tr>
<td><select name="dateRange.simpleDate" onchange="selectRadioButton('simpleDate')" >

<%perl>
foreach my $f (@date) {
    my ($key, $value) = @$f;

    next if !$date_aliases{$key};
    my $selected = $key eq $date ? qq{selected} : "";
    print qq{<option value="$key" $selected>$value</option>\n};
}
</%perl>

</select></td>
</tr>
</table>
</td>
</tr>
<tr>
<td><input type="radio" name="dateRange.dateRangeType" value="custom" id="customDate" <% $date_range_selected_custom %>></td>
<td nowrap>
<table>
<tr>
<td nowrap>
<div class="errorbox-good"><select name="dateRange.customDate.start.day" onchange="selectRadioButton('customDate')" >

<%perl>
for my $day (1 .. 31) {
   print qq{<option value="$day">$day</option>\n};
}
</%perl>

</select>

<select name="dateRange.customDate.start.month" onchange="selectRadioButton('customDate')">
<%perl>
  for (my $i = 0; $i <= $#month; $i++) {
        my $selected = $i == $t_month ? 'selected' : '';
	print qq{<option $selected value="}, $i+1, qq{">}, $month[$i], qq{</option>\n};
  }
</%perl>
</select> <select name="dateRange.customDate.start.year" onchange="selectRadioButton('customDate')">
<%perl>
  for (my $i = $year_begin; $i < $year_begin + $year_period; $i++) {
        my $selected = $i == $t_year ? 'selected' : '';
	print qq{<option $selected value="$i">$i</option>\n};
  }
</%perl>
</select><br></div>
</td>
<td>-</td>
<td nowrap>
<div class="errorbox-good"><select name="dateRange.customDate.end.day" onchange="selectRadioButton('customDate')">
<%perl>
for my $day (1 .. 31) {
   my $selected = $day == $t_day ? 'selected' : '';
   print qq{<option value="$day" $selected>$day</option>\n};
}
</%perl>
</select> <select name="dateRange.customDate.end.month" onchange="selectRadioButton('customDate')">
<%perl>
  for (my $i = 0; $i <= $#month; $i++) {
        my $selected = $i == $t_month ? 'selected' : '';
	print qq{<option $selected value="}, $i+1, qq{">}, $month[$i], qq{</option>\n};
  }
</%perl>
</select> <select name="dateRange.customDate.end.year" onchange="selectRadioButton('customDate')">
<%perl>
  for (my $i = $year_begin; $i < $year_begin + $year_period; $i++) {
        my $selected = $i == $t_year ? 'selected' : '';
	print qq{<option $selected value="$i">$i</option>\n};
  }
</%perl>
</select><br></div>
</td>
</tr>
</table>
</td>
</tr>

</table>
