<%args>
$type
$id
# e.g. type=searchable, id=A.idtest-abebooks-0
$remove => 0 # If true, remove instead of adding
</%args>
<%perl>
# The hard part of this is avoiding the creation of duplicates.  We
# need to iterate over each corresponding library realm in order to
# insert the new record into it; as we do so, we probe each realm in
# turn to discover whether the record is already there.  (We can't
# simply change the Torus code so that it rejects such duplicates,
# since in some circumstances they are necessary.)
#
# The simplest way to do this would be to iterate over all destination
# realms; but that might add to some realms that are not otherwise
# accessible from MKAdmin due to the lack of a library administrator
# record.  So instead, we iterate over administrators and work on the
# realms that they are responsible for.

my $admin = $m->notes("admin");
my $user = $m->comp("/mc/utils/user.mc", require => 1) or return;
my $myRealm = $user->field("identityId");
my $record = $admin->torus()->recordByArgs(realm => $myRealm, id => $id)
    or die "no record '$id' for realm '$myRealm'";

my $uri = $record->uri();
my $adminAdmin = new Masterkey::Admin("admin");
my $adminTorus = $adminAdmin->torus();
my $adminRs = $adminTorus->records("admin", "cql.allRecords=1 sortby displayName");
my($present, $prep, $past) = !$remove ? ("Adding", "to", "Added") : ("Removing", "from", "Removed");
my $recname = $record->displayName();
print "   <p>$present $recname $prep ", $adminRs->alln(), " libraries:</p>\n";

my $destinationAdmin = new Masterkey::Admin($type);
my $destinationTorus = $destinationAdmin->torus();

my $count = 0;
print "   <ul>\n";
foreach (my $i = 0 ; $i < $adminRs->alln(); $i++) {
    my $library = $adminRs->record($i);
    my $libRealm = $library->field("identityId");
    my $rs = $destinationTorus->records($libRealm, qq[originalUri=="$uri"]);
    if ($remove) {
	if ($rs->alln == 0) {
	    print "    <li>", $library->displayName(), " ($libRealm) does not have this record</li>\n";
	} else {
	    my $id = $rs->record(0)->field("id") || die "arrgh!";
	    $destinationTorus->deleteByArgs(realm => $libRealm, id => $id);
	    print "    <li>Removed $id from ", $library->displayName(), " ($libRealm)</li>\n";
	    $count++;
	}
	next;
    }

    if ($rs->alln() > 0) {
	print "    <li>", $library->displayName(), " ($libRealm) already has this record</li>\n";
    } else {
	my $worldRs = $destinationTorus->world($libRealm, qq[originalUri=="$uri"]);
	if ($worldRs->alln() == 0) {
	    # This happens if a destination realm doesn't have the relevant parent
	    print "<li>no world-record in '$libRealm' with originalUri='$uri'</li>\n";
	} else {
	    my $worldId = $worldRs->record(0)->field("id") || die "argh!";
	    my $newid = $destinationTorus->add(0, $libRealm, $worldId, $library);
	    print "    <li>Added to ", $library->displayName(), " ($libRealm) -> $newid</li>\n";
	    $count++;
	}
    }
}
print "   </ul>\n";
print "<p>$past $recname $prep $count libraries.</p>\n";
</%perl>
